//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//---------------------------

#include "math.h"

#include "mbs_data.h"
#include "user_IO.h"
#include "user_model.h"
#include "user_all_id.h"

double user_LinkForces(double Z, double Zd, MbsData *mbs_data, double tsim, int ilnk)
{
    
    double Flink = 0;
    
/*-- Begin of user code --*/

    switch(ilnk)
    {
        // get the link id
        case MyLink_id :
        {
            // retrieve the user model
            UserModel *um = mbs_data->user_model;
            double K  = um->mylink.K;
            double C  = um->mylink.C;
            double L0 = um->mylink.L0;

            Flink = K*(Z-L0)+C*Zd;

            break;
        }
    }

/*-- End of user code --*/    
    
    return  Flink;
}
